/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.modifiers;

import com.rcx.materialis.modifiers.CapacitorModifier;
import com.rcx.materialis.util.TinkerToolFluxed;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class PowerHungryModifier
extends CapacitorModifier {
    private static final int ENERGY_COST = 100;

    public int getPriority() {
        return 160;
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        TinkerToolFluxed.removeEnergy(tool, 100 * level, false, true);
        return amount;
    }

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        if (TinkerToolFluxed.removeEnergy(tool, 100 * level, true, false)) {
            return damage;
        }
        return damage / 1.5f;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        if (!TinkerToolFluxed.removeEnergy(tool, 100 * level, true, false)) {
            event.setNewSpeed(event.getNewSpeed() / 1.5f);
        }
    }

    @Override
    public int getCapacity() {
        return 10000;
    }
}

